# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 2
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR2_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early Rounds (1-3): Cooperate to build trust
    if current_round <= 3:
        return "C"
    
    # Mid Rounds (4-7)
    elif current_round <= 7:
        # If opponent has mostly cooperated (<=1 defection), continue cooperating
        if opp_history.count("D") <= 1:
            return "C"
        # If opponent has defected >=2 times, switch to TFT
        else:
            return opp_history[-1]
    
    # Late Rounds (8-10)
    else:
        total_rounds = len(opp_history)
        coop_rate = opp_history.count("C") / total_rounds if total_rounds > 0 else 1.0
        
        # If opponent has cooperated >=70%, defect in last 2 rounds to exploit
        if coop_rate >= 0.7:
            if current_round >= 9:
                return "D"
            else:
                return "C"
        # If opponent has defected frequently (>30%), continue TFT
        else:
            return opp_history[-1]